<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Chart with Zooming / Panning</h1>
<div id="chartContainer"></div>

<?php
	$dataPoints = array();
	$y = 40;
	for ($i = 0; $i < 1000; $i++) {
		$y += rand(0, 10) - 5;
		array_push($dataPoints, array("x" => $i, "y" => $y));
	}
?>

<script>
	window.onload = function() {
		var chart = new CanvasJS.Chart("chartContainer", {
			theme: "light2", // "light1", "light2", "dark1", "dark2"
			animationEnabled: true,
			zoomEnabled: true,
			title: {
				text: "Try Zooming and Panning"
			},
			data: [{
				type: "area",
				dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
			}]
		});
		chart.render();

	}
</script>

<?php include '../footer.php'; ?>